
function ResizeLetterBox(clip c, int dstwidth, int dstheight)
{
	asratiosrc = float(c.width)/float(c.height)
	asratiodst = float(dstwidth)/float(dstheight)
	
	# Calculate no distort dst size, and fill border to the result size
	
	(asratiosrc > asratiodst) ? Eval("""
	
		tmpheight = int(dstwidth/asratiosrc)/2*2
		c = c.SWScale(dstwidth, tmpheight)
		
		topborder = (dstheight - tmpheight)/2
		bottomborder = (dstheight - tmpheight) - topborder
		c = c.AddBorders(0, topborder, 0, bottomborder)
	
	""") : Eval("""
	
		tmpwidth = int(dstheight*asratiosrc)/4*4
	  c = c.SWScale(tmpwidth, dstheight)
	
		leftborder = (dstwidth - tmpwidth)/2
		rightborder = (dstwidth - tmpwidth) - leftborder
		c = c.AddBorders(leftborder, 0, rightborder, 0)
	
	""")
	
	return c
}

function ResizePanScan(clip c, int dstwidth, int dstheight)
{
	asratiosrc = float(c.width)/float(c.height)
	asratiodst = float(dstwidth)/float(dstheight)
	
	# Calculate no distort src clip rect, and strech it to the dst size

	(asratiosrc > asratiodst) ? Eval("""
	
		srcwidth = int(c.height*asratiodst)/4*4
		leftcrop = (c.width - srcwidth)/2
		c = c.crop(leftcrop/4*4, 0, srcwidth/4*4, c.height)
		c = c.SWScale(dstwidth, dstheight)
	
	""") : Eval("""
	
		srcheight = int(c.width/asratiodst)/2*2
		topcrop = (c.height - srcheight)/2
		c = c.crop(0, topcrop/2*2, c.width, srcheight/2*2)
		c = c.SWScale(dstwidth, dstheight)
	
	""")
	
	return c
}

function ResizeMedium(clip c, int dstwidth, int dstheight)
{
	asratiosrc = float(c.width)/float(c.height)
	asratiodst = float(dstwidth)/float(dstheight)
	
	(asratiosrc > asratiodst) ? Eval("""

		srcwidth = int(c.height*asratiodst)/2*2
		crop = int((c.width - srcwidth)/4)/2*2
		
		tmpheight = int(dstHeight*srcwidth/(srcwidth+crop*2))/2*2
		border = int((dstheight - tmpheight)/2)/2*2

		c = c.crop(crop/4*4, 0, (c.width - crop*2)/4*4, c.height)
		c = c.SWScale(dstwidth, tmpheight)
		c = c.AddBorders(0, border, 0, dstHeight-tmpheight-border)
	
	""") : Eval("""
	
		srcheight = int(c.width/asratiodst)
		crop = int((c.height - srcheight)/4)
		
		tmpwidth = int(dstwidth*(srcheight)/(srcheight+crop*2))/4*4
		border = int((dstwidth - tmpwidth)/2)/4*4
		
		c = c.crop(0, crop/2*2, c.width, (c.height - crop * 2)/2*2)
		c = c.SWScale(tmpwidth, dstheight)
		c = c.AddBorders(border, 0, dstwidth-tmpwidth-border, 0)
	
	""")
	
	return c
}

function ResizeZoom(clip c, int dstwidth, int dstheight)
{
	c = c.SWScale(dstwidth, dstheight)
	return c
}
function DisplayRatio(clip c, float dr)
{
	sr = float(c.width)/float(c.height)
	(sr < dr) ? Eval("""
	
		tmpwidth = int(c.height*dr)/4*4
		c = c.SWScale(tmpwidth, c.height)
	
	""") : Eval("""
	
		tmpheight = int(c.width/dr)/2*2
	  c = c.SWScale(c.width, tmpheight)
	
	""")
	
	return c
}